// Initialize state
let isGrayscale = false;

// Listen for messages from the extension
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === 'toggleGrayscale') {
    toggleGrayscale();
  }
});

// Function to toggle grayscale
function toggleGrayscale() {
  isGrayscale = !isGrayscale;
  if (isGrayscale) {
    document.documentElement.classList.add('bw-grayscale');
  } else {
    document.documentElement.classList.remove('bw-grayscale');
  }
}

// Add keyboard shortcut (Ctrl/Cmd + Shift + G)
document.addEventListener('keydown', (e) => {
  if ((e.ctrlKey || e.metaKey) && e.shiftKey && e.key.toLowerCase() === 'g') {
    toggleGrayscale();
  }
}); 